% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-selregion.R, R/op-cdo-selcircle.R,
%   R/op-cdo-selregion.R
\name{selregion}
\alias{selregion}
\alias{cdo_selcircle}
\alias{cdo_selregion}
\title{Select horizontal regions}
\usage{
cdo_selcircle(
  ifile,
  regions = NULL,
  lon = NULL,
  lat = NULL,
  radius = NULL,
  ofile = NULL
)

cdo_selregion(
  ifile,
  regions = NULL,
  lon = NULL,
  lat = NULL,
  radius = NULL,
  ofile = NULL
)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{regions}{STRING - Comma-separated list of ASCII formatted files with different regions}

\item{lon}{FLOAT - Longitude of the center of the circle in degrees, default lon=0.0}

\item{lat}{FLOAT - Latitude of the center of the circle in degrees, default lat=0.0}

\item{radius}{STRING - Radius of the circle, default radius=1deg (units: deg, rad, km, m)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
Selects all grid cells with the center point inside user defined regions or a circle. The resulting grid is unstructured.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{selregion  Select cells inside regions
           Selects all grid cells with the center point inside the regions.
           Regions can be defined by the user via an ASCII file.
           Each region consists of the geographic coordinates of a polygon.
           Each line of a polygon description file contains the longitude and latitude of one point.
           Each polygon description file can contain one or more polygons separated by a line with the character \\\\&amp;.
           
           Predefined regions of countries can be specified via the country codes.
           A country is specified with dcw:&lt;CountryCode&gt;. Country codes can be combined with the plus sign.
selcircle  Select cells inside a circle
           Selects all grid cells with the center point inside a circle. The circle is described by geographic coordinates
           of the center and the radius of the circle.
}\if{html}{\out{</div>}}
}
