% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_corpus_ms2020sample}
\alias{data_corpus_ms2020sample}
\title{Sample corpus of political speeches from Maerz & Schneider (2020)}
\format{
A \link[quanteda:corpus]{corpus} object.
The corpus consists of 100 speeches randomly sampled from 40 heads of
government across 27 countries, balanced by regime type. The corpus
contains the following document-level variables:
\describe{
\item{speaker}{Character. Name of the head of government.}
\item{country}{Character. Country name.}
\item{regime}{Factor. Regime type: "Democracy" or "Autocracy".}
\item{score}{Numeric. Original dictionary-based liberal-illiberal score.}
\item{date}{Date. Date of the speech.}
\item{title}{Character. Title of the speech.}
}
}
\usage{
data_corpus_ms2020sample
}
\description{
A corpus of 100 speeches from the Maerz & Schneider (2020) corpus,
balanced across regime types (50 autocracies, 50 democracies). This sample
is included in the package for demos and testing. The full corpus of 4,740
speeches is available in the package's pkgdown examples folder.
}
\examples{
if (requireNamespace("quanteda", quietly = TRUE)) {
  # Inspect the corpus
  summary(data_corpus_ms2020sample, n = 10)

  # Regime distribution
  table(data_corpus_ms2020sample$regime)

  # View a sample speech
  cat(data_corpus_ms2020sample[1])
}
}
\references{
Maerz, S. F., & Schneider, C. Q. (2020). Comparing public communication in
democracies and autocracies: Automated text analyses of speeches by heads
of government. \emph{Quality & Quantity}, 54, 517-545.
\doi{10.1007/s11135-019-00885-7}
}
\keyword{data}
