% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pscEst_run.R
\name{pscEst_run}
\alias{pscEst_run}
\title{Running the Bayesian MCMC routine
A procedure which runs the MCMC estimation routine}
\usage{
pscEst_run(pscOb, nsim, nchain)
}
\arguments{
\item{pscOb}{an pscOb object which has been passed through pscData() and
init() functions}

\item{nsim}{the number of MCMC simulations to run}

\item{nchain}{Number of chains to use for analysis}
}
\value{
An updated set of attributes for the pscOb which includes
}
\description{
Running the Bayesian MCMC routine
A procedure which runs the MCMC estimation routine
}
\examples{
e4_data <- psc::e4_data
gemCFM <- psc::gemCFM
pscOb <- pscData(gemCFM,e4_data)
pscOb <- init(pscOb)
pscOb <- pscEst_start(pscOb,nsim=1000,nchain=2)
pscOb <- pscEst_run(pscOb,nsim=1000,nchain=2)
}
