% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plinkQC-package.R
\docType{package}
\name{plinkQC-package}
\alias{plinkQC}
\alias{plinkQC-package}
\title{plinkQC: Genotype Quality Control with 'PLINK'}
\description{
Genotyping arrays enable the direct measurement of an individuals genotype at thousands of markers. 'plinkQC' facilitates genotype quality control for genetic association studies as described by Anderson and colleagues (2010) \doi{10.1038/nprot.2010.116}. It makes 'PLINK' basic statistics (e.g. missing genotyping rates per individual, allele frequencies per genetic marker) and relationship functions accessible from 'R' and generates a per-individual and per-marker quality control report. Individuals and markers that fail the quality control can subsequently be removed to generate a new, clean dataset. Removal of individuals based on relationship status is optimised to retain as many individuals as possible in the study. Additionally, there is a trained classifier to predict genomic ancestry of human samples.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://meyer-lab-cshl.github.io/plinkQC/}
  \item Report bugs at \url{https://github.com/meyer-lab-cshl/plinkQC/issues}
}

}
\author{
\strong{Maintainer}: Hannah Meyer \email{maha.s.syed@gmail.com} (\href{https://orcid.org/0000-0003-4564-0899}{ORCID})

Other contributors:
\itemize{
  \item Caroline Walter \email{carowalter26@hotmail.com} [contributor]
  \item Maha Syed \email{maha.s.syed@gmail.com} [contributor]
}

}
\keyword{internal}
