# phymapnet

PhyMapNet: phylogeny-aware microbial network inference with optional hyperparameter-ensemble edge reliability.

## Installation

```r
# install.packages("devtools")
devtools::install_github("YOUR_GITHUB_USERNAME/phymapnet")
```

## Quick start

```r
library(phymapnet)
library(ape)

# otu: samples x taxa matrix (rownames=samples, colnames=taxa)
# tree: phylo object with tip labels = taxa

fit <- phymapnet_fit(
  otu, tree,
  alpha = 0.05, k = 5,
  epsilon1 = 0.1, epsilon2 = 0.1,
  kernel = "gaussian",
  th_sparsity = 0.95,
  normalization = "gmpr"
)

res <- phymapnet_reliability(
  otu, tree,
  th_fixed = 0.95,
  kernels = c("gaussian"),
  consensus_cut = 0.5
)

# Outputs:
# res$rel_mat, res$consensus_mat, res$edge_list
```
