% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_photon.R
\name{new_photon}
\alias{new_photon}
\title{Initialize a photon instance}
\usage{
new_photon(
  path = NULL,
  url = NULL,
  photon_version = NULL,
  country = NULL,
  date = "latest",
  exact = FALSE,
  section = NULL,
  opensearch = TRUE,
  mount = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{path}{Path to a directory where the photon executable and data
should be stored. Defaults to a directory "photon" in the current
working directory. If \code{NULL}, a remote instance is set up based on
the \code{url} parameter.}

\item{url}{URL of a photon server to connect to. If \code{NULL} and
\code{path} is also \code{NULL}, connects to the public API under
\url{https://photon.komoot.io/}.}

\item{photon_version}{Version of photon to be used. A list of all
releases can be found here: \url{https://github.com/komoot/photon/releases/}.
Ignored if \code{jar} is given. If \code{NULL}, uses the latest known
version.}

\item{country}{Character string that can be identified by
\code{\link[countrycode]{countryname}} as a country. An extract for this
country will be downloaded. If \code{"planet"}, downloads a global search
index. If \code{NULL}, downloads no index and leaves download or import to
the user.}

\item{date}{Character string or date-time object used to specify the creation
date of the search index. If \code{"latest"}, will download the file tagged
with "latest". If a character string, the value should be parseable by
\code{\link{as.POSIXct}}. If \code{exact = FALSE}, the input value is
compared to all available dates and the closest date will be selected.
Otherwise, a file will be selected that exactly matches the input to
\code{date}.}

\item{exact}{If \code{TRUE}, exactly matches the \code{date}. Otherwise,
selects the date with lowest difference to the \code{date} parameter.}

\item{section}{Subdirectory of the download server from which to select a
search index. If \code{"experimental"}, selects a dump made for the master
version of photon. If \code{"archived"}, selects a dump made for an older
version of photon. If \code{NULL} (or any arbitrary string), selects a
dump made for the current release. Defaults to \code{NULL}.}

\item{opensearch}{If \code{TRUE}, attempts to download the OpenSearch
version of photon. OpenSearch-based photon supports structrued geocoding.
Readily available OpenSearch photon executables are only offered since
photon version 0.6.0. For earlier versions, you need to build it from
source using gradle. In this case, if \code{TRUE}, will look for an
OpenSearch version of photon in the specified path. Since photon version
0.7.0, OpenSearch is the recommended option. Defaults to \code{TRUE}.}

\item{mount}{If \code{TRUE}, mounts the object to the session so that
functions like \code{\link{geocode}} automatically detect the new
instance. If \code{FALSE}, initializies the instance but doesn't mount
it to the session. Defaults to \code{TRUE}.}

\item{overwrite}{If \code{TRUE}, overwrites existing jar files and
search indices when initializing a new instance. Defaults to
\code{FALSE}.}

\item{quiet}{If \code{TRUE}, suppresses all informative messages.}
}
\value{
An R6 object of class \code{photon}.
}
\description{
Initialize a photon instance by creating a new photon object. This object
is stored in the R session and can be used to perform geocoding requests.

Instances can either be local or remote. Remote instances require nothing
more than a URL that geocoding requests are sent to. Local instances require
the setup of the photon executable, a search index, and Java. See
\code{\link{photon_local}} for details.
}
\examples{
# connect to public API
photon <- new_photon()

# connect to arbitrary server
photon <- new_photon(url = "https://photonserver.org")

if (has_java("11")) {
# set up a local instance in a temporary directory
dir <- file.path(tempdir(), "photon")
photon <- new_photon(dir, country = "Monaco")
}

photon$purge(ask = FALSE)
}
