% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-spct-ratios-fractions.r
\name{Tfr_normdiff}
\alias{Tfr_normdiff}
\alias{Tfr_normdiff.default}
\alias{Tfr_normdiff.filter_spct}
\alias{Tfr_normdiff.filter_mspct}
\title{transmittance:transmittance normalised difference}
\usage{
Tfr_normdiff(
  spct,
  w.band.plus,
  w.band.minus,
  scale.factor,
  wb.trim,
  use.cached.mult,
  use.hinges,
  ...
)

\method{Tfr_normdiff}{default}(
  spct,
  w.band.plus,
  w.band.minus,
  scale.factor,
  wb.trim,
  use.cached.mult,
  use.hinges,
  ...
)

\method{Tfr_normdiff}{filter_spct}(
  spct,
  w.band.plus = NULL,
  w.band.minus = NULL,
  scale.factor = 1,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = NULL,
  quantity = "mean",
  naming = "short",
  name.tag = NULL,
  ...
)

\method{Tfr_normdiff}{filter_mspct}(
  spct,
  w.band.plus = NULL,
  w.band.minus = NULL,
  scale.factor = 1,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = NULL,
  quantity = "mean",
  naming = "short",
  name.tag = NULL,
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an object of class "filter_spct".}

\item{w.band.plus, w.band.minus}{waveband object(s) or a list(s) of waveband
objects used to compute the additive and subtractive transmittance terms of
the normalized difference index.}

\item{scale.factor}{numeric vector of length 1, or length equal to that of
\code{w.band}. Numeric multiplier applied to returned values.}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{...}{other arguments (possibly ignored)}

\item{quantity}{character One of "total", "average" or "mean".}

\item{naming}{character one of "long", "default", "short" or "none". Used to
select the type of names to assign to returned value.}

\item{name.tag}{character Used to tag the name of the returned values.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax
for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
In the case of methods for individual spectra, a \code{numeric}
  vector with name attribute set. The name is based on the name of the
  wavebands unless a named list of wavebands is supplied in which case the
  names of the list elements are used. "[Tfr:Tfr]" is appended if
  \code{quantity= "total"} and "[Tfr(wl):Tfr(wl)]" if
  \code{quantity = "mean"} or \code{quantity = "average"}.

  A \code{data.frame} is returned in the case of collections of spectra,
  containing one column for each fraction definition, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  Fraction definitions are "assembled" from the arguments passed to
  \code{w.band.num} and \code{w.band.denom}. If both arguments are lists of
  waveband definitions, with an equal number of members, then the wavebands
  are paired to obtain as many fractions as the number of wavebands in each
  list. Recycling for wavebands takes place when the number of denominator
  and numerator wavebands differ.
}
\description{
Transmittance normalized difference index for a given
pair of wavebands computed from a filter spectrum.
}
\details{
With the default \code{quantity = "mean"} or
 \code{quantity = "average"} the ratio is based on
 two \strong{mean spectral photon transmittances}, one computed for each
 waveband.

  \deqn{\frac{\overline{\mathrm{Tfr}_\lambda}(s, wb_\mathrm{plus}) - \overline{\mathrm{Tfr}_\lambda}(s, wb_\mathrm{minus})}{\overline{\mathrm{Tfr}_\lambda}(s, wb_\mathrm{plus}) + \overline{\mathrm{Tfr}_\lambda}(s, wb_\mathrm{minus})}}

If the argument is set to \code{quantity = "total"} the fraction is based on
  two \strong{photon transmittances}, one computed for each waveband.

  \deqn{\frac{\mathrm{Tfr}(s, wb_\mathrm{plus}) - \mathrm{Tfr}(s, wb_\mathrm{minus})}{\mathrm{Tfr}(s, wb_\mathrm{plus}) + \mathrm{Tfr}(s, wb_\mathrm{minus})}}

Only if the wavelength expanse of the two wavebands is the same, these two
ratios are numerically identical.
}
\section{Methods (by class)}{
\itemize{
\item \code{Tfr_normdiff(default)}: Default for generic function

\item \code{Tfr_normdiff(filter_spct)}: Method for \code{filter_spct} objects

\item \code{Tfr_normdiff(filter_mspct)}: Calculates Tfr:Tfr from a \code{filter_mspct}
object.

}}
\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in most cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult =T RUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
Tfr_normdiff(Ler_leaf_rflt.spct,
             waveband(c(400,500), wb.name = "Blue"),
             waveband(c(600,700), wb.name = "Red"))
Tfr_normdiff(Ler_leaf_rflt.spct,
             waveband(c(400,500), wb.name = "Blue"),
             waveband(c(600,700), wb.name = "Red"),
             quantity = "total")
Tfr_normdiff(Ler_leaf_rflt.spct,
             waveband(c(400,500), wb.name = "Blue"),
             waveband(c(600,700), wb.name = "Red"),
             quantity = "mean")

}
\seealso{
\code{\link{normalized_diff_ind}}, accepts different summary
functions.

Other transmittance ratio functions: 
\code{\link{Tfr_fraction}()},
\code{\link{Tfr_ratio}()}
}
\concept{transmittance ratio functions}
