% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguMissingsCharacterizer.R
\name{pgu.missingsCharacterizer}
\alias{pgu.missingsCharacterizer}
\title{pgu.missingsCharacterizer}
\format{
[R6::R6Class] object.
}
\description{
A class that characterizes the origin of missing values.
}
\details{
A class that characterizes the origin of missing values.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureAlphabet}}{Returns the instance variable featureAlphabet.
(character)}

\item{\code{featureAgent}}{Returns the instance variable featureAgent.
(character)}

\item{\code{setFeatureAgent}}{Sets the instance variable featureAgent.
(character)}

\item{\code{missingsCharacteristics_df}}{Returns the instance variable missingsCharacteristics_df.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pgu.missingsCharacterizer-new}{\code{pgu.missingsCharacterizer$new()}}
\item \href{#method-pgu.missingsCharacterizer-finalize}{\code{pgu.missingsCharacterizer$finalize()}}
\item \href{#method-pgu.missingsCharacterizer-print}{\code{pgu.missingsCharacterizer$print()}}
\item \href{#method-pgu.missingsCharacterizer-reset}{\code{pgu.missingsCharacterizer$reset()}}
\item \href{#method-pgu.missingsCharacterizer-analyze}{\code{pgu.missingsCharacterizer$analyze()}}
\item \href{#method-pgu.missingsCharacterizer-plot_pair_dist}{\code{pgu.missingsCharacterizer$plot_pair_dist()}}
\item \href{#method-pgu.missingsCharacterizer-clone}{\code{pgu.missingsCharacterizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-new"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new `pgu.missingsCharacterizer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$new(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `pgu.missingsCharacterizer` object.
(pguIMP::pgu.missingsCharacterizer)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of `pgu.missingsCharacterizer` is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-print"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a `pgu.missingsCharacterizer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-reset"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-reset}{}}}
\subsection{Method \code{reset()}}{
Takes a dataframe that will be analyzed using the analyze function
and resets the instance variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$reset(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-analyze}{}}}
\subsection{Method \code{analyze()}}{
resets the instance variables and analyzes a dataframe.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$analyze(data_df = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-plot_pair_dist"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-plot_pair_dist}{}}}
\subsection{Method \code{plot_pair_dist()}}{
Plots the analysis result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$plot_pair_dist(data_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_df}}{The data to be analyzed.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pgu.missingsCharacterizer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pgu.missingsCharacterizer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.missingsCharacterizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
