% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vctrs-panel_data.R
\name{build_panel_data}
\alias{build_panel_data}
\title{Lightweight panel_data constructor}
\usage{
build_panel_data(
  x,
  id,
  wave,
  periods = NULL,
  reshaped = NULL,
  varying = NULL,
  constants = NULL,
  validate_order = FALSE
)
}
\arguments{
\item{x}{A data frame to convert}

\item{id}{Name of the id column (string)}

\item{wave}{Name of the wave column (string)}

\item{periods}{Vector of time periods (optional)}

\item{reshaped}{Logical indicating if data was reshaped (optional)}

\item{varying}{Character vector of varying variable names (optional)}

\item{constants}{Character vector of constant variable names (optional)}

\item{validate_order}{If TRUE, check if data is sorted and re-sort if not.
Default FALSE for speed. Set TRUE when row order might have changed.}
}
\value{
A panel_data object
}
\description{
Internal helper function for fast reconstruction of panel_data objects.
Unlike \code{\link[=panel_data]{panel_data()}}, this does NOT validate, sort, or set up grouping
by default. It simply attaches attributes and class. Use for fast
reconstruction after operations that preserve the panel structure.
}
\details{
Set \code{validate_order = TRUE} to check if data is sorted and fix if needed.
The check is O(n); sorting only happens if data is actually unsorted.
}
\keyword{internal}
