% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationships.R
\name{RelationshipsResource}
\alias{RelationshipsResource}
\title{Relationships Resource}
\value{
Relationships data with pagination metadata.

Relationship types with pagination metadata.
}
\description{
R6 class providing access to relationship operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RelationshipsResource-new}{\code{RelationshipsResource$new()}}
\item \href{#method-RelationshipsResource-get}{\code{RelationshipsResource$get()}}
\item \href{#method-RelationshipsResource-types}{\code{RelationshipsResource$types()}}
\item \href{#method-RelationshipsResource-print}{\code{RelationshipsResource$print()}}
\item \href{#method-RelationshipsResource-clone}{\code{RelationshipsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelationshipsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-RelationshipsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new RelationshipsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelationshipsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelationshipsResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-RelationshipsResource-get}{}}}
\subsection{Method \code{get()}}{
Get relationships for a concept.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelationshipsResource$get(
  concept_id,
  relationship_ids = NULL,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  include_invalid = FALSE,
  standard_only = FALSE,
  include_reverse = FALSE,
  page = 1,
  page_size = 100,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{relationship_ids}}{Filter by relationship type IDs (character vector or comma-separated string).}

\item{\code{vocabulary_ids}}{Filter by target vocabulary IDs (character vector or comma-separated string).}

\item{\code{domain_ids}}{Filter by target domain IDs (character vector or comma-separated string).}

\item{\code{include_invalid}}{Include relationships to invalid concepts. Default \code{FALSE}.}

\item{\code{standard_only}}{Only include relationships to standard concepts. Default \code{FALSE}.}

\item{\code{include_reverse}}{Include reverse relationships. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page (max 1000). Default 100.}

\item{\code{vocab_release}}{Specific vocabulary release version. Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelationshipsResource-types"></a>}}
\if{latex}{\out{\hypertarget{method-RelationshipsResource-types}{}}}
\subsection{Method \code{types()}}{
Get available relationship types from the OMOP CDM.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelationshipsResource$types(page = 1, page_size = 100)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page (max 500). Default 100.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelationshipsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-RelationshipsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelationshipsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RelationshipsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RelationshipsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RelationshipsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
