% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glean_vt.R
\name{glean_vt}
\alias{glean_vt}
\title{Parse data from requests to VecTraits}
\usage{
glean_vt(res, cols = NULL, returnunique = FALSE)
}
\arguments{
\item{res}{a list of responses from VecTraits as an \code{ohvbd.responses} object.}

\item{cols}{a character vector of columns to extract from the dataset.}

\item{returnunique}{whether to return only the unique rows within each dataset according to the filtered columns.}
}
\value{
An \code{ohvbd.data.frame} containing the requested data.
}
\description{
Extract the data returned by a call to \code{\link[=fetch_vt]{fetch_vt()}}, filter columns of interest, and find unique rows if required.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vt(54) |>
  glean_vt(cols=c("DatasetID",
                    "Interactor1Genus",
                    "Interactor1Species"),
             returnunique=TRUE)

ohvbd.ids(54, "vt") |>
  fetch() |>
  glean() # Calls glean_vt()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vectraits}
