% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nl_free.R
\name{nl_free}
\alias{nl_free}
\title{Free geocoding search}
\usage{
nl_free(
  q,
  rows = NULL,
  start = NULL,
  fq = NULL,
  lat = NULL,
  lon = NULL,
  type = NULL,
  fl = NULL,
  df = NULL,
  ...,
  verbose = FALSE
)
}
\arguments{
\item{q}{query to geocoding service.}

\item{rows}{maximum number of rows to be returned. Default is 10.}

\item{start}{start index.Default is 0.}

\item{fq}{apply a filter to the query, e.g. fq=bron:BAG. The default filter is 'type:(municipality OR town OR neiborhood OR road OR postcode OR adress)'. Use fq=* to remove the default filter.}

\item{lat}{enter a decimal degree (latitude, in WGS84). Together with lon this will define a point to search from. Search results will be ordered by distance from this point. For example: 'lat=52.09&lon=5.12'}

\item{lon}{enter a decimal degree (longitude, in WGS84). Together with lat this will define  point to search from. Search results will be ordered by distance from this point. For example: 'lat=52.09&lon=5.12'}

\item{type}{restrict the results on a specific type.}

\item{fl}{fields to return.}

\item{df}{field that should be search in.}

\item{...}{parameters passed to the pdok webservice}

\item{verbose}{\code{logical} should the function print out messages.}
}
\value{
The result of the pdok free webservice converted to a R list object.
}
\description{
This function wraps the "free" pdok service, and allows for free search.
For syntax and examples see the documentation of pdok.
A more easy/convenient but simpler function for geocoding is
\code{\link[=nl_geocode]{nl_geocode()}}.
}
\examples{
if (requireNamespace("sf", quietly = TRUE)){
  l <- nl_free("Henri Faasdreef 312")
  l$response$numFound
  l$response$docs["weergavenaam"]
}
}
\seealso{
\code{\link[=nl_geocode]{nl_geocode()}}
}
