% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellate.R
\name{vertices_to_parcels}
\alias{vertices_to_parcels}
\title{Aggregate vertex data into parcels}
\usage{
vertices_to_parcels(data, labels, summary_func = mean)
}
\arguments{
\item{data}{Numeric vector of vertex-level values.}

\item{labels}{Integer vector of parcel labels. \code{0} and \code{NA} are treated as
medial wall and excluded.}

\item{summary_func}{Function to summarise each parcel (default: \link{mean}).}
}
\value{
Named numeric vector of parcel-level values.
}
\description{
Summarises vertex-level data by parcellation labels.
}
\examples{
data <- c(1.0, 2.0, 3.0, 4.0)
labels <- c(1L, 1L, 2L, 2L)
vertices_to_parcels(data, labels)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
