% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellate.R
\name{unparcellate}
\alias{unparcellate}
\title{Unparcellate brain map data}
\usage{
unparcellate(parcel_data, parcellation, fill = NA_real_)
}
\arguments{
\item{parcel_data}{Named numeric vector of parcel values.}

\item{parcellation}{Integer vector of labels or file path to a GIFTI label
file.}

\item{fill}{Value for medial wall vertices (default: \code{NA_real_}).}
}
\value{
Numeric vector of vertex-level values.
}
\description{
Inverse of \code{\link[=parcellate]{parcellate()}}: maps parcel-level values back to vertices.
}
\examples{
parcel_data <- c("1" = 10, "2" = 20)
labels <- c(1L, 1L, 2L, 2L, 0L)
unparcellate(parcel_data, labels)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
