% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{transform_to_space}
\alias{transform_to_space}
\title{Transform brain maps between coordinate spaces}
\usage{
transform_to_space(
  paths,
  target_space = c("fsLR", "fsaverage"),
  target_density = "32k",
  hemisphere = c("left", "right"),
  method = c("adaptive", "barycentric"),
  area_surf_current = NULL,
  area_surf_new = NULL,
  wb_path = NULL,
  verbose = TRUE
)
}
\arguments{
\item{paths}{Character vector of GIFTI file paths to transform.}

\item{target_space}{Target coordinate space: \code{"fsLR"} or \code{"fsaverage"}.}

\item{target_density}{Target mesh density (e.g., \code{"32k"}, \code{"164k"}).}

\item{hemisphere}{Which hemispheres to transform: \code{"left"}, \code{"right"},
or both.}

\item{method}{Resampling method: \code{"adaptive"} (default) or
\code{"barycentric"}.}

\item{area_surf_current}{Path to the current-resolution area-correction
surface (e.g. midthickness). Recommended when \code{method = "adaptive"} for
proper vertex-area correction (matches neuromaps Python behaviour).}

\item{area_surf_new}{Path to the target-resolution area-correction surface.
If \code{NULL} and \code{area_surf_current} is provided, ciftiTools resamples it
barycentrically.}

\item{wb_path}{Path to \code{wb_command} executable. If \code{NULL}, auto-detected
via \code{ciftiTools}.}

\item{verbose}{Logical, print progress messages.}
}
\value{
Character vector of transformed file paths.
}
\description{
Resamples GIFTI surface files between \code{fsaverage} and \code{fsLR} coordinate
spaces using Connectome Workbench via \code{ciftiTools}.
}
\examples{
\dontrun{
transform_to_space("map.func.gii", target_space = "fsLR")
}
}
\references{
Robinson EC et al. (2014) NeuroImage 100:414-426.
doi:10.1016/j.neuroimage.2014.07.033

Robinson EC et al. (2018) NeuroImage 167:150-165.
doi:10.1016/j.neuroimage.2017.10.037
}
