% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_brain_map_values}
\alias{read_brain_map_values}
\title{Read vertex/voxel values from a brain map file}
\usage{
read_brain_map_values(path)
}
\arguments{
\item{path}{Path to a \code{.func.gii} (GIFTI) or \code{.nii.gz} (NIfTI) file.}
}
\value{
A numeric vector of map values.
}
\description{
Reads GIFTI (\code{.func.gii}) or NIfTI (\code{.nii.gz}) files and returns the
values as a numeric vector. Used internally by \code{\link[=compare_maps]{compare_maps()}} when
file paths are passed instead of numeric vectors.
}
\examples{
\dontrun{
read_brain_map_values("cortical_thickness.func.gii")
read_brain_map_values("brain_volume.nii.gz")
}
}
