% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{permtest_metric}
\alias{permtest_metric}
\title{Permutation test for any metric between brain maps}
\usage{
permtest_metric(
  x,
  y,
  metric_func = stats::cor,
  n_perm = 1000L,
  seed = NULL,
  null_method = NULL,
  distmat = NULL,
  coords = NULL,
  parcellation = NULL,
  ...
)
}
\arguments{
\item{x, y}{Numeric vectors.}

\item{metric_func}{Function taking \verb{(x, y)} and returning a scalar.}

\item{n_perm}{Integer number of permutations.}

\item{seed}{Optional integer seed for reproducibility.}

\item{null_method}{Optional null model method passed to \code{\link[=generate_nulls]{generate_nulls()}}.
If \code{NULL}, uses simple random permutation.}

\item{distmat}{Distance matrix (passed to \code{\link[=generate_nulls]{generate_nulls()}} if needed).}

\item{coords}{Coordinate list (passed to \code{\link[=generate_nulls]{generate_nulls()}} if needed).}

\item{parcellation}{Integer vector (passed to \code{\link[=generate_nulls]{generate_nulls()}} if needed).}

\item{...}{Additional arguments passed to \code{\link[=generate_nulls]{generate_nulls()}}.}
}
\value{
List with \verb{$observed}, \verb{$null_values}, \verb{$p_value}, and \verb{$n_perm}.
}
\description{
Computes a user-specified metric between two vectors and tests significance
using either spatially-constrained null surrogates or simple random
permutation.
}
\examples{
x <- rnorm(100)
y <- x + rnorm(100)
result <- permtest_metric(x, y, n_perm = 99L, seed = 1L)
result$observed
result$p_value
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
