% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellate.R
\name{parcellate}
\alias{parcellate}
\title{Parcellate brain map data}
\usage{
parcellate(data, parcellation, summary_func = mean)
}
\arguments{
\item{data}{Numeric vector or file path to a GIFTI/NIfTI brain map.}

\item{parcellation}{Integer vector of labels or file path to a GIFTI label
file.}

\item{summary_func}{Function to summarise each parcel (default: \link{mean}).}
}
\value{
Named numeric vector of parcel-level values.
}
\description{
High-level wrapper that reads data and parcellation from file paths or
vectors, then aggregates vertices into parcels.
}
\examples{
data <- c(1.0, 2.0, 3.0, 4.0)
labels <- c(1L, 1L, 2L, 2L)
parcellate(data, labels)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
