% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-spin.R
\name{null_spin_vasa}
\alias{null_spin_vasa}
\alias{null_spin_hungarian}
\title{Spin-test null models for brain maps}
\usage{
null_spin_vasa(
  data,
  coords,
  n_perm = 1000L,
  seed = NULL,
  rotation = c("euler", "rodrigues")
)

null_spin_hungarian(
  data,
  coords,
  n_perm = 1000L,
  seed = NULL,
  rotation = c("euler", "rodrigues")
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{coords}{List with \verb{$lh} and \verb{$rh} matrices of spherical coordinates
(n x 3 each).}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{rotation}{Rotation generation method: \code{"euler"} (ZYZ Euler angles,
default, matches neuromaps Python) or \code{"rodrigues"} (Rodrigues axis-angle
formula).}
}
\value{
A \link{null_distribution} object.
}
\description{
Generate spatially-constrained null distributions using spin-based
permutation of spherical coordinates.
}
\examples{
coords <- list(lh = matrix(rnorm(30), 10, 3), rh = matrix(rnorm(30), 10, 3))
data <- rnorm(20)
nd <- null_spin_vasa(data, coords, n_perm = 10L, seed = 1L)
}
\references{
Alexander-Bloch AF et al. (2018) NeuroImage 175:111-120.
doi:10.1016/j.neuroimage.2018.04.023

Vasa F et al. (2018) Cerebral Cortex 28:3293-3303.
doi:10.1093/cercor/bhx195

Markello RD, Misic B (2021) NeuroImage 236:118052.
doi:10.1016/j.neuroimage.2021.118052
}
