% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-cornblath.R
\name{null_cornblath}
\alias{null_cornblath}
\title{Cornblath spin test null model}
\usage{
null_cornblath(
  data,
  coords,
  parcellation,
  n_perm = 1000L,
  seed = NULL,
  rotation = c("euler", "rodrigues")
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{coords}{List with \verb{$lh} and \verb{$rh} matrices of spherical coordinates
(n x 3 each).}

\item{parcellation}{Integer vector of parcel labels for all vertices.
\code{0} and \code{NA} indicate medial wall.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{rotation}{Rotation generation method: \code{"euler"} (ZYZ Euler angles,
default, matches neuromaps Python) or \code{"rodrigues"} (Rodrigues axis-angle
formula).}
}
\value{
A \link{null_distribution} object.
}
\description{
Spin-based null model where each rotated vertex receives the label of its
nearest non-medial-wall original vertex, then parcels are reassigned by
majority vote among the resulting vertex labels.
}
\examples{
coords <- list(lh = matrix(rnorm(30), 10, 3), rh = matrix(rnorm(30), 10, 3))
parcellation <- c(rep(1L, 5), rep(2L, 5), rep(3L, 5), rep(4L, 5))
data <- c(1.0, 2.0, 3.0, 4.0)
nd <- null_cornblath(data, coords, parcellation, n_perm = 10L, seed = 1L)
}
\references{
Cornblath EJ et al. (2020) Communications Biology 3:590.
doi:10.1038/s42003-020-01296-5
}
