% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface-graph.R
\name{make_surf_graph}
\alias{make_surf_graph}
\title{Build an igraph from a triangular surface mesh}
\usage{
make_surf_graph(vertices, faces)
}
\arguments{
\item{vertices}{Numeric matrix (n x 3) of vertex coordinates.}

\item{faces}{Integer matrix (m x 3) of face indices (1-indexed).}
}
\value{
An \code{igraph} graph object with weighted edges.
}
\description{
Extracts unique edges from triangular faces, computes Euclidean edge weights,
and returns an igraph graph object suitable for geodesic distance
computation.
}
\examples{
vertices <- matrix(
  c(0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1),
  nrow = 4, byrow = TRUE
)
faces <- matrix(c(1L, 2L, 3L, 2L, 3L, 4L), nrow = 2, byrow = TRUE)
g <- make_surf_graph(vertices, faces)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
