% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcellate.R
\name{get_parcel_centroids}
\alias{get_parcel_centroids}
\title{Compute parcel centroids}
\usage{
get_parcel_centroids(
  vertices,
  labels,
  method = c("average", "surface", "geodesic"),
  faces = NULL
)
}
\arguments{
\item{vertices}{Numeric matrix (n x 3) of vertex coordinates.}

\item{labels}{Integer vector of parcel labels. \code{0} and \code{NA} are medial wall.}

\item{method}{Centroid method: \code{"average"} (coordinate means), \code{"surface"}
(vertex closest to the average centroid), or \code{"geodesic"} (vertex
minimizing sum of geodesic distances within parcel).}

\item{faces}{Integer matrix (m x 3) of face indices. Required for
\code{"geodesic"} method.}
}
\value{
Numeric matrix (n_parcels x 3) with rownames set to parcel labels.
}
\description{
Finds the centroid of each parcel using one of three methods.
}
\examples{
vertices <- matrix(rnorm(30), ncol = 3)
labels <- c(1L, 1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L, 3L)
get_parcel_centroids(vertices, labels, method = "average")
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
