% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_maps}
\alias{compare_maps}
\alias{print.neuromaps_enhanced_comparison}
\title{Compare brain maps with spatial null model significance testing}
\usage{
compare_maps(
  x,
  y,
  method = c("pearson", "spearman"),
  null_method = NULL,
  n_perm = 1000L,
  nulls = NULL,
  distmat = NULL,
  coords = NULL,
  seed = NULL,
  na.rm = TRUE,
  verbose = TRUE,
  ...
)

\method{print}{neuromaps_enhanced_comparison}(x, ...)
}
\arguments{
\item{x, y}{Numeric vectors of brain map values, or file paths to
GIFTI/NIfTI files.}

\item{method}{Correlation method: \code{"pearson"} or \code{"spearman"}.}

\item{null_method}{Optional null model method for empirical p-values.
One of \code{"burt2020"}, \code{"moran"}, \code{"spin_vasa"}, \code{"spin_hungarian"},
\code{"alexander_bloch"}, \code{"baum"}, \code{"cornblath"}, \code{"burt2018"},
or \code{NULL} for parametric only.}

\item{n_perm}{Integer number of null permutations.}

\item{nulls}{Pre-computed \link{null_distribution} object for \code{x}.}

\item{distmat}{Distance matrix (passed to null model if needed).}

\item{coords}{Coordinate list (passed to spin null models if needed).}

\item{seed}{Optional integer seed for reproducibility.}

\item{na.rm}{Logical, remove NA values before computing correlation.}

\item{verbose}{Logical, print progress messages.}

\item{...}{Additional arguments passed to \code{\link[=generate_nulls]{generate_nulls()}}.}
}
\value{
A \code{neuromaps_enhanced_comparison} object (inherits
\code{neuromaps_comparison}) with additional fields \code{p_null}, \code{null_method},
\code{null_r}, and \code{n_perm}.
}
\description{
Computes the correlation between two brain maps and optionally tests
significance using a spatial null model to account for spatial
autocorrelation.
}
\examples{
x <- rnorm(50)
y <- x + rnorm(50)
compare_maps(x, y, verbose = FALSE)
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
