% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.R
\name{cut.nifti}
\alias{cut.nifti}
\alias{cut.anlz}
\title{Perform Cut on an image}
\usage{
\method{cut}{nifti}(x, breaks, ..., mask)

\method{cut}{anlz}(x, ..., mask)
}
\arguments{
\item{x}{Object of class \code{nifti}}

\item{breaks}{either a numeric vector of two or more unique cut points 
or a single number (greater than or equal to 2) 
giving the number of intervals into which x is to be cut. 
Passed to \code{\link{cut}})}

\item{...}{Arguments passed to \code{\link{cut}}}

\item{mask}{object to subset the image.  If missing, then all 
values of the image are used}
}
\value{
Object of class \code{nifti} with an \code{attribute} of levels
}
\description{
Cuts a numeric image into an integer factor,
 with the option of a mask.
}
\examples{
img = nifti(array(rnorm(10^3), dim = rep(10, 3)))
mask = img > 0
cut(img, mask = mask, breaks = 4)
}
