% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_learners.R
\name{lnr_homoskedastic_density}
\alias{lnr_homoskedastic_density}
\title{Conditional Density Estimation with Homoskedasticity Assumption}
\usage{
lnr_homoskedastic_density(
  data,
  formula,
  mean_lnr,
  mean_lnr_args = NULL,
  density_args = NULL,
  weights = NULL
)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{mean_lnr}{A learner (function) passed in to be trained on the data with
the given formula and then used to predict conditional means for provided
\code{newdata}.}

\item{mean_lnr_args}{Extra arguments to be passed to the \code{mean_lnr}}

\item{density_args}{Extra arguments to be passed to the kernel
density smoother \code{stats::density}, especially things like
\code{bw} for specifying the smoothing bandwidth. See \code{?stats::density}.}

\item{weights}{Observation weights; see \code{?lm}}
}
\value{
A predictor function that takes in \code{newdata} and produces density
estimates
}
\description{
This function accepting an \code{mean_lnr}, which it then trains on the data
and formula given. Then \code{stats::density} is fit to the error (difference
between observed outcome and the \code{mean_lnr} predictions).
}
\details{
This returns a function that takes in \code{newdata} and produces density
estimates according to the estimated \code{stats::density} fit the error
from the \code{newdata} observed outcome and the prediction from the \code{mean_lnr}.

That is to say, this follows the following procedure (assuming \eqn{Y} as the outcome
and \eqn{X} as a matrix of predictors):

\deqn{\texttt{obtain } \hat{\mathbb E}(Y | X) \quad \mathtt{using \quad mean\_learner}}
\deqn{\texttt{fit } \hat{f} \gets \mathtt{density}(Y - \hat{\mathbb E}(Y | X))}
\deqn{\mathtt{return \quad  function(newdata) \{ } \hat{f}(\mathtt{newdata\$Y} -
  \hat{\mathbb E}[Y | \mathtt{newdata\$X}]) \} }
}
\examples{
# fit a conditional density model with mean model as a randomForest
fit_density_lnr <- lnr_homoskedastic_density(
  data = mtcars,
  formula = mpg ~ hp,
  mean_lnr = lnr_rf)

# and what we should get back should be predicted densities at the
# observed mpg given the covariates hp
fit_density_lnr(mtcars)
}
