% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_projector.R
\name{bi_projector}
\alias{bi_projector}
\title{Construct a bi_projector instance}
\usage{
bi_projector(v, s, sdev, preproc = prep(pass()), classes = NULL, ...)
}
\arguments{
\item{v}{A matrix of coefficients with dimensions \code{nrow(v)} by \code{ncol(v)} (columns = components)}

\item{s}{The score matrix}

\item{sdev}{The standard deviations of the score matrix}

\item{preproc}{(optional) A pre-processing pipeline, default is prep(pass())}

\item{classes}{(optional) A character vector specifying the class attributes of the object, default is NULL}

\item{...}{Extra arguments to be stored in the \code{projector} object.}
}
\value{
A bi_projector object
}
\description{
A bi_projector offers a two-way mapping from samples (rows) to scores and from variables (columns) to components.
Thus, one can project from D-dimensional input space to d-dimensional subspace. And one can project (project_vars) from n-dimensional
variable space to the d-dimensional component space. The singular value decomposition is a canonical example of such a two-way mapping.
}
\examples{
X <- matrix(rnorm(200), 10, 20)
svdfit <- svd(X)

p <- bi_projector(svdfit$v, s = svdfit$u \%*\% diag(svdfit$d), sdev=svdfit$d)
}
