% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_nextN}
\alias{calc_nextN}
\title{Project stock abundance to the next time step}
\usage{
calc_nextN(
  N,
  surv,
  na = dim(N)[1],
  nr = dim(N)[2],
  ns = dim(N)[3],
  advance_age = TRUE,
  mov = array(1/nr, c(na, nr, nr, ns)),
  plusgroup = TRUE
)
}
\arguments{
\item{N}{Abundance at current time step. Array \verb{[a, r, s]}}

\item{surv}{Survival during the current time step. Array \verb{[a, r, s]}}

\item{na}{Integer, number of age classes}

\item{nr}{Integer, number of regions}

\item{ns}{Integer, number of stocks}

\item{advance_age}{Logical, whether the animals advance to their next age class}

\item{mov}{Movement array in the next time step. Array \verb{[a, r, r, s]}. Rows denote region of origin and columns denote region of destination.}

\item{plusgroup}{Logical, whether the last age class is an accumulator plus group.}
}
\value{
Abundance at the next time step. Array \verb{[a, r, s]}
}
\description{
This function applies survival of the current abundance, advances
age classes, re-distributes the stock using the movement matrix.
}
