% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R
\name{SwipeableDrawer}
\alias{SwipeableDrawer}
\title{SwipeableDrawer}
\usage{
SwipeableDrawer(...)
}
\arguments{
\item{...}{Props to pass to the component.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/swipeable-drawer/}
}
\details{
\itemize{
\item onClose \code{func} \cr Default is - Callback fired when the component requests to be closed.Signature:function(event: React.SyntheticEvent ) = voidevent The event source of the callback.
\item onOpen \code{func} \cr Default is - Callback fired when the component requests to be opened.Signature:function(event: React.SyntheticEvent ) = voidevent The event source of the callback.
\item allowSwipeInChildren \code{func| bool} \cr Default is FALSE If set to true, the swipe event will open the drawer even if the user begins the swipe on one of the drawer's children. This can be useful in scenarios where the drawer is partially visible. You can customize it further with a callback that determines which children the user can drag over to open the drawer (for example, to ignore other elements that handle touch move events, like sliders).
\item children \code{node} \cr Default is - The content of the component.
\item disableBackdropTransition \code{bool} \cr Default is FALSE Disable the backdrop transition. This can improve the FPS on low-end devices.
\item disableDiscovery \code{bool} \cr Default is FALSE If true, touching the screen near the edge of the drawer will not slide in the drawer a bit to promote accidental discovery of the swipe gesture.
\item disableSwipeToOpen \code{bool} \cr Default is typeof navigator !== 'undefined' && /iPad|iPhone|iPod/.test(navigator.userAgent) If true, swipe to open is disabled. This is useful in browsers where swiping triggers navigation actions. Swipe to open is disabled on iOS browsers by default.
\item hysteresis \code{number} \cr Default is 0.52 Affects how far the drawer must be opened/closed to change its state. Specified as percent (0-1) of the width of the drawer
\item minFlingVelocity \code{number} \cr Default is 450 Defines, from which (average) velocity on, the swipe is defined as complete although hysteresis isn't reached. Good threshold is between 250 - 1000 px/s
\item open \code{bool} \cr Default is FALSE If true, the component is shown.
\item slotProps \verb{\{ backdrop?: func| object, docked?: func| object, paper?: func| object, root?: func| object, swipeArea?: func| object, transition?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ backdrop?: elementType, docked?: elementType, paper?: elementType, root?: elementType, swipeArea?: elementType, transition?: elementType \}} \cr Default is The components used for each slot inside.
\item SwipeAreaProps \code{object} \cr Default is - The element is used to intercept the touch events on the edge.Deprecated use the slotProps.swipeArea prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item swipeAreaWidth \code{number} \cr Default is 20 The width of the left most (or right most) area in px that the drawer can be swiped open from.
\item transitionDuration \verb{number| \{ appear?: number, enter?: number, exit?: number \}} \cr Default is enter: theme.transitions.duration.enteringScreen, exit: theme.transitions.duration.leavingScreen, The duration for the transition, in milliseconds. You may specify a single timeout for all transitions, or individually with an object.
}
}
