% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{predict.mtar}
\alias{predict.mtar}
\title{Forecasting for multivariate TAR models}
\usage{
\method{predict}{mtar}(
  object,
  ...,
  newdata,
  n.ahead = 1,
  row.names,
  credible = 0.95,
  out.of.sample = FALSE
)
}
\arguments{
\item{object}{An object of class \code{mtar} obtained from a call to \code{mtar()}.}

\item{...}{Additional arguments that may affect the prediction method.}

\item{newdata}{An optional \code{data.frame} containing future values of the threshold
series (if included in the fitted model), the exogenous series (if included in the fitted
model), and, when \code{out.of.sample = TRUE}, the realized values of the output series.}

\item{n.ahead}{A positive integer specifying the number of steps ahead to forecast.}

\item{row.names}{An optional variable in \code{newdata} specifying labels for the time}

\item{credible}{An optional numeric value in \eqn{(0,1)} specifying the level of the
required credible intervals. By default, \code{credible} is set to \code{0.95}.}

\item{out.of.sample}{An optional logical indicator. If \code{TRUE} then the log-score,
Absolute Error (AE), Absolute Percentage Error (APE) and Squared Error (SE) are computed
as measures of predictive accuracy. In this case, \code{newdata} must include the observed
values of the output series.}
}
\value{
A list containing the forecast summaries and, when requested, measures of predictive accuracy.

\tabular{ll}{
\code{ypred}   \tab a matrix with the results of the forecasting,\cr
\tab \cr
\code{summary} \tab a matrix with the mean and credible intervals of the forecasting,\cr
}
}
\description{
Computes forecasts from a fitted multivariate Threshold Autoregressive (TAR) model.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1 <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
             subset={Date<="2016-03-14"}, dist="Student-t",
             ars=ars(nregim=3,p=c(1,1,2)), n.burnin=2000, n.sim=3000,
             n.thin=2, ssvs=TRUE)
out1 <- predict(fit1, newdata=subset(returns,Date>"2016-03-14"), n.ahead=10)
out1$summary

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2 <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
             subset={Date<="2009-04-04"}, dist="Laplace",
             ars=ars(nregim=3,p=5), n.burnin=2000, n.sim=3000, n.thin=2)
out2 <- predict(fit2, newdata=subset(riverflows,Date>"2009-04-04"), n.ahead=10)
out2$summary

###### Example 3: Temperature, precipitation, and two river flows in Iceland
data(iceland.rf)
fit3 <- mtar(~ Jokulsa + Vatnsdalsa | Temperature | Precipitation,
             data=iceland.rf, subset={Date<="1974-12-21"}, row.names=Date,
             ars=ars(nregim=2,p=15,q=4,d=2), n.burnin=2000, n.sim=3000,
             n.thin=2)
out3 <- predict(fit3, newdata=subset(iceland.rf,Date>"1974-12-21"), n.ahead=10)
out3$summary
}
}
\references{
Nieto, F.H. (2005) Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data.
            Communications in Statistics - Theory and Methods, 34, 905-930.

Romero, L.V. and Calderon, S.A. (2021) Bayesian estimation of a multivariate TAR model when the noise
            process follows a Student-t distribution. Communications in Statistics - Theory and Methods, 50, 2508-2530.

Calderon, S.A. and Nieto, F.H. (2017) Bayesian analysis of multivariate threshold autoregressive models
            with missing data. Communications in Statistics - Theory and Methods, 46, 296-318.

Karlsson, S. (2013) Chapter 15-Forecasting with Bayesian Vector Autoregression. In Elliott, G. and
            Timmermann, A. Handbook of Economic Forecasting, Volume 2, 791–89, Elsevier.

Vanegas, L.H. and Calderón, S.A. and Rondón, L.M. (2025) Bayesian estimation of a multivariate tar model when the
            noise process distribution belongs to the class of gaussian variance mixtures. International Journal
            of Forecasting.
}
