% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{US.returns}
\alias{US.returns}
\title{U.S. Stock Returns}
\format{
A data frame with 5606 rows and 4 variables:
\describe{
  \item{Date}{A vector indicating the date of each observation.}
  \item{CCR}{A numeric vector giving the continuously compounded returns.}
  \item{SR}{A numeric vector giving the simple returns.}
  \item{dVIX}{A numeric vector giving (the first difference of) the Chicago
              Board Options Exchange Market Volatility Index (VIX).}
}
}
\usage{
data(US.returns)
}
\description{
The dataset comprises observations of both continuously compounded and
simple returns derived from the S&P 500 index, along with the first difference of
the Chicago Board Options Exchange Market Volatility Index (VIX). The sample period
spans from January 5, 1990, to March 30, 2012.
}
\examples{
data(US.returns)
dev.new()
plot(ts(as.matrix(US.returns[,-1])), main="Returns and (the first difference of) VIX")

}
\references{
Massacci, D. (2014) A two-regime threshold model with conditional skewed
            student-t distributions for stock returns. Economic Modelling, 43, 9-20.
}
\keyword{datasets}
