% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.sim_com_data.R
\name{update.sim_com_data}
\alias{update.sim_com_data}
\title{Update \code{sim_com_data} Object}
\usage{
\method{update}{sim_com_data}(object, ..., evaluate = TRUE)
}
\arguments{
\item{object}{A \code{sim_com_data} object, as returned by \code{\link[=initialise_com]{initialise_com()}}.}

\item{...}{Named arguments to update. These should be valid arguments to \code{initialise_com()}.
If \code{kernel_fun} is updated, any associated \code{kernel_args} (if present in previous call) will also be replaced.}

\item{evaluate}{Logical (default \code{TRUE}). If \code{TRUE}, the function returns the re-evaluated
updated object; if \code{FALSE}, it returns the updated function call without evaluating it.}
}
\value{
If \code{evaluate = TRUE}, a new \code{sim_com_data} object with updated parameters.
If \code{evaluate = FALSE}, a \code{call} object representing the updated function call.
}
\description{
Updates the parameters used to create a \code{sim_com_data} object, returned
by \code{\link[=initialise_com]{initialise_com()}}.
}
\details{
\itemize{
\item If dispersal-related arguments such as \code{max_dist}, \code{kernel_fun}, or \code{kernel_args}
are changed, the existing \code{dlist} is removed and recalculated unless a new \code{dlist}
is explicitly provided.
\item If \code{n1_map} or \code{K_map} is updated, the \code{dlist} will also be removed to
ensure consistency.
}
}
\examples{
\donttest{
library(terra)

# Read data from the mrangr package

## Input maps
K_map <- rast(system.file("input_maps/K_map_eg.tif", package = "mrangr"))
n1_map <- rast(system.file("input_maps/n1_map_eg.tif", package = "mrangr"))

## Competition coefficients matrix
a <- a_eg

# Initialise simulation parameters
community_01 <-
  initialise_com(
  K_map = K_map,
  r = 1.1,
  a = a,
  rate = 0.002)

# Update simulation parameters

# Custom kernel function
abs_rnorm <- function(n, mean, sd) {
  abs(rnorm(n, mean = mean, sd = sd))
}

community_02 <- update(community_01,
  kernel_fun = c("rexp", "rexp", "abs_rnorm", "abs_rnorm"),
  kernel_args = list(
   list(rate = 0.002),
   list(rate = 0.001),
   list(mean = 0, sd = 1000),
   list(mean = 0, sd = 2000)))
}

}
\seealso{
\code{\link[=initialise_com]{initialise_com()}}
}
