% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_autocorrelation.R
\name{compute_spatial_autocorr}
\alias{compute_spatial_autocorr}
\title{Compute Moran's I & LISA, classify clusters}
\usage{
compute_spatial_autocorr(sf_data, values, signif = 0.05)
}
\arguments{
\item{sf_data}{An \code{sf} object containing spatial features.}

\item{values}{A numeric vector or column name with the variable to test.}

\item{signif}{Numeric significance level threshold for clusters (default 0.05).}
}
\value{
A named list with elements:
\itemize{
\item \code{data}: An \code{sf} object with added columns for standardized values,
spatial lag, local Moran's I values, z-scores, p-values, and cluster classification.
\item \code{moran}: An object of class \code{htest} with global Moran's I test results.
}
}
\description{
Computes global and local Moran’s I to assess spatial autocorrelation
and classifies observations into spatial cluster types (e.g., High-High).
}
\examples{
\donttest{
library(sf)
library(spdep)
library(dplyr)

#Load and prepare spatial data
mapdata <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
mapdata <- st_make_valid(mapdata)

#Variable to analyze
values <- rnorm(nrow(mapdata))

#Run function
result <- compute_spatial_autocorr(mapdata, values, signif = 0.05)

#Inspect results
head(result$data)
result$moran
}

}
