% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_pkgs.R
\name{install_pkgs}
\alias{install_pkgs}
\alias{extract_pkgs}
\alias{extract_pkgs.character}
\alias{extract_pkgs.R6}
\alias{extract_pkgs.list}
\alias{extract_pkgs.ResampleResult}
\alias{extract_pkgs.BenchmarkResult}
\title{Install (Missing) Packages}
\usage{
install_pkgs(x, ...)

extract_pkgs(x)

\method{extract_pkgs}{character}(x)

\method{extract_pkgs}{R6}(x)

\method{extract_pkgs}{list}(x)

\method{extract_pkgs}{ResampleResult}(x)

\method{extract_pkgs}{BenchmarkResult}(x)
}
\arguments{
\item{x}{(any)\cr
Object with package information (or a list of such objects).}

\item{...}{(any)\cr
Additional arguments passed down to \code{\link[remotes:install_cran]{remotes::install_cran()}} or
\code{\link[remotes:install_github]{remotes::install_github()}}.
Arguments \code{force} and \code{upgrade} are often important in this context.}
}
\value{
\code{extract_pkgs()} returns a \code{character()} of package strings,
\code{install_pkgs()} returns the names of extracted packages invisibly.
}
\description{
\code{extract_pkgs()} extracts required package from various objects, including
\link{TaskGenerator}, \link{Learner}, \link{Measure} and objects from
extension packages such as \CRANpkg{mlr3pipelines} or \CRANpkg{mlr3filters}.
If applied on a list, the function is called recursively on all elements.

\code{install_pkgs()} calls \code{extract_pkgs()} internally and proceeds with the
installation of extracted packages.
}
\details{
If a package contains a forward slash ('/'), it is assumed to be a package hosted
on GitHub in \code{"<user>/<repo>"} format, and the string will be passed to
\code{\link[remotes:install_github]{remotes::install_github()}}.
Otherwise, the package name will be passed to \code{\link[remotes:install_cran]{remotes::install_cran()}}.
}
\examples{
extract_pkgs(lrns(c("regr.rpart", "regr.featureless")))
}
