% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KendallCCA.R
\name{myrcc}
\alias{myrcc}
\title{Internal RidgeCCA function}
\usage{
myrcc(R1, R2, R12, lambda1, lambda2, tol = 1e-04)
}
\arguments{
\item{R1}{correlation/covariance/rank-based correlation matrix of dataset \code{X1}.}

\item{R2}{correlation/covariance/rank-based correlation matrix of dataset \code{X2}.}

\item{R12}{correlation/covariance/rank-based correlation matrix between dataset \code{X1} and dataset \code{X2}.}

\item{lambda1}{tuning parameter (a scalar value) for dataset \code{X1}.}

\item{lambda2}{tuning parameter (a scalar value) for dataset \code{X2}.}

\item{tol}{tolerance for eigenvalues. Refer to \code{standardCCA} function.}
}
\value{
\code{myrcc} returns a data.frame containing
\itemize{
      \item cancor: estimated canonical correlation.
      \item w1: estimated canonical direction \eqn{w1}.
      \item w2: estimated canonical direction \eqn{w2}.
}
}
\description{
This function is modified from CCA package rcc function. This function is used for simulation. Inputs should be correlation or covariance matrices of each data set and between datasets.
}
