% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{register_serial}
\alias{register_serial}
\title{Register Serialization Configuration}
\usage{
register_serial(class, sfunc, ufunc)
}
\arguments{
\item{class}{(character) class name(s) for custom serialization, e.g.
\code{'ArrowTabular'} or \code{c('torch_tensor', 'ArrowTabular')}.}

\item{sfunc}{(function | list) serialization function(s) accepting a
reference object and returning a raw vector.}

\item{ufunc}{(function | list) unserialization function(s) accepting a raw
vector and returning a reference object.}
}
\value{
Invisible NULL.
}
\description{
Registers a serialization configuration, which may be set to perform custom
serialization and unserialization of normally non-exportable reference
objects, allowing these to be used seamlessly between different R sessions.
Once registered, the functions apply to all \code{\link[=daemons]{daemons()}} calls where the
\code{serial} argument is \code{NULL}.
}
