% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/plot_mgwrsar.R
\name{plot,mgwrsar,missing-method}
\alias{plot,mgwrsar,missing-method}
\alias{plot.mgwrsar}
\title{Plot method for mgwrsar model}
\usage{
\S4method{plot}{mgwrsar,missing}(
  x,
  y,
  type = "coef",
  var = NULL,
  crs = NULL,
  mypalette = "RdYlGn",
  opacity = 0.8,
  size = 5,
  title = NULL,
  show_legend = TRUE,
  n_time_steps = 10,
  ...
)

\method{plot}{mgwrsar}(
  x,
  type = "coef",
  var = NULL,
  crs = NULL,
  mypalette = "RdYlGn",
  size = 5,
  opacity = 0.8,
  title = NULL,
  show_legend = TRUE,
  n_time_steps = 10,
  ...
)
}
\arguments{
\item{x}{An object of class \code{mgwrsar}.}

\item{y}{missing (not used).}

\item{type}{Character. The type of output to plot. Options are:
\itemize{
  \item \code{'coef'}: Spatially varying coefficients (default).
  \item \code{'t_coef'}: t-statistics of the coefficients (visualized with a significance threshold of 1.96).
  \item \code{'residuals'}: Model residuals.
  \item \code{'fitted'}: Fitted values.
}}

\item{var}{Character. The name of the variable (covariate) to plot. Required if \code{type} is \code{'coef'} or \code{'t_coef'}.}

\item{crs}{Numeric or character. The Coordinate Reference System (e.g., EPSG code) of the coordinates.
If \code{NULL}, the function attempts to retrieve the CRS from \code{x@my_crs}.}

\item{mypalette}{Character. The color palette to use for the points (e.g., "RdYlGn", "Viridis"). Default is "RdYlGn".}

\item{opacity}{Numeric. The opacity of the markers, between 0 and 1. Default is 0.8.}

\item{size}{Numeric. The size of the markers. Default is 5.}

\item{title}{Character. A custom title for the plot. If \code{NULL}, a default title is automatically generated.}

\item{show_legend}{Logical. Whether to display the legend. Default is \code{TRUE}.}

\item{n_time_steps}{time step for spatio-temporal model (default 10).}

\item{...}{Additional arguments passed to the internal plot function.}
}
\value{
An interactive Plotly object (Mapbox or Scatter).

A \code{plotly} object representing the interactive plot (or map).
}
\description{
Maps the results of an mgwrsar model using an interactive Plotly map.
Supports plotting coefficients, t-statistics, residuals, and fitted values.
Automatically switches between a geographic map (if CRS is present) and a scatter plot.

Visualizes the results of an MGWRSAR model (coefficients, t-statistics, residuals, or fitted values)
using interactive plots via the \code{plotly} package.

If a Coordinate Reference System (CRS) is provided (either via the \code{crs} argument or stored in the model object),
the function generates an interactive map. Otherwise, it generates a standard scatter plot of the values
against the coordinates.
}
\seealso{
\code{\link{MGWRSAR}}
}
