% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vic}
\alias{vic}
\title{Victoria Local Government Areas (\code{sf})}
\format{
An \code{\link[sf:sf]{sf}} object with:
\describe{
\item{LGA_NAME}{Character, LGA name (upper case).}
\item{geometry}{\code{MULTIPOLYGON} / \code{POLYGON} in a projected CRS.}
}
}
\source{
Prepared in \code{data-raw/gen-data.R}. Update this if you include an
external data source.
}
\usage{
vic
}
\description{
An example polygon layer of Victoria's LGAs for demos and tests.
Built from \code{data-raw/map/LGA_POLYGON.shp}, Z/M dropped, transformed to a
projected CRS, simplified, validated, and reduced to \code{LGA_NAME} + geometry.
}
\details{
The CRS stored in the object is whatever \code{st_crs(vic)} reports at build time.
In \code{data-raw/gen-data.R} we:
\enumerate{
\item drop Z/M (\code{st_zm()}),
\item transform to a projected CRS (\code{st_transform()}),
\item simplify (\code{st_simplify(dTolerance = 100)}),
\item repair geometries (\code{st_make_valid()}),
\item upper-case names and select columns.
}
}
\examples{
library(sf)
plot(sf::st_geometry(vic), col = "grey90", border = "grey50")
}
\keyword{datasets}
