% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_functions.R
\name{compare_scenarios}
\alias{compare_scenarios}
\title{Compare Multiple Analysis Scenarios}
\usage{
compare_scenarios(
  scenario_list,
  metrics = c("sources", "sinks", "balanced", "excluded"),
  create_plots = TRUE,
  output_dir = NULL
)
}
\arguments{
\item{scenario_list}{Named list of analysis results from run_builtin_analysis()}

\item{metrics}{Character vector of metrics to compare. Options: "sources",
"sinks", "balanced", "excluded", "total_surplus", "total_deficit"}

\item{create_plots}{Logical. Create comparison plots? (default: TRUE)}

\item{output_dir}{Character. Directory for saving plots (default: NULL, no save)}
}
\value{
List containing:
\item{comparison_data}{Data frame with metrics for each scenario}
\item{plots}{List of ggplot objects (if create_plots = TRUE)}
\item{summary}{Summary statistics}
}
\description{
Compare results from multiple analysis runs side-by-side with visualizations
and summary statistics.
}
\examples{
\donttest{
# Create multiple scenarios
base <- run_builtin_analysis(year = 2016, include_wwtp = FALSE,
                              scale = "county", nutrients = "nitrogen")
wwtp <- run_builtin_analysis(year = 2016, include_wwtp = TRUE,
                              scale = "county", nutrients = "nitrogen")

# Compare scenarios
comparison <- compare_scenarios(list(
  "Base (Agricultural Only)" = base,
  "With WWTP" = wwtp
))

# View comparison data
print(comparison$comparison_data)

# View plots
print(comparison$plots$bar_chart)
}
}
