% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_r_plot_orchestrator.R
\name{BaseRPlotOrchestrator}
\alias{BaseRPlotOrchestrator}
\title{Base R Plot Orchestrator Class}
\description{
Base R Plot Orchestrator Class

Base R Plot Orchestrator Class
}
\details{
This class orchestrates the detection and processing of multiple layers
in Base R plots. It analyzes each recorded plot call individually and combines
the results into a comprehensive interactive plot.
}
\keyword{-}
\keyword{Unified}
\keyword{all}
\keyword{by}
\keyword{creation}
\keyword{internal}
\keyword{layer}
\keyword{plot}
\keyword{processor}
\keyword{types}
\keyword{used}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{plot_calls}}{List of recorded Base R plot calls}

\item{\code{layers}}{List of detected layer information}

\item{\code{layer_processors}}{List of layer-specific processors}

\item{\code{combined_data}}{Combined data from all layers}

\item{\code{combined_selectors}}{Combined selectors from all layers}

\item{\code{layout}}{Layout information from the plot}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{plot_calls}}{List of recorded Base R plot calls}

\item{\code{layers}}{List of detected layer information}

\item{\code{layer_processors}}{List of layer-specific processors}

\item{\code{combined_data}}{Combined data from all layers}

\item{\code{combined_selectors}}{Combined selectors from all layers}

\item{\code{layout}}{Layout information from the plot}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseRPlotOrchestrator-new}{\code{BaseRPlotOrchestrator$new()}}
\item \href{#method-BaseRPlotOrchestrator-detect_layers}{\code{BaseRPlotOrchestrator$detect_layers()}}
\item \href{#method-BaseRPlotOrchestrator-analyze_single_layer}{\code{BaseRPlotOrchestrator$analyze_single_layer()}}
\item \href{#method-BaseRPlotOrchestrator-create_layer_processors}{\code{BaseRPlotOrchestrator$create_layer_processors()}}
\item \href{#method-BaseRPlotOrchestrator-create_layer_processor}{\code{BaseRPlotOrchestrator$create_layer_processor()}}
\item \href{#method-BaseRPlotOrchestrator-create_unified_layer_processor}{\code{BaseRPlotOrchestrator$create_unified_layer_processor()}}
\item \href{#method-BaseRPlotOrchestrator-process_layers}{\code{BaseRPlotOrchestrator$process_layers()}}
\item \href{#method-BaseRPlotOrchestrator-extract_format_config_from_axis_calls}{\code{BaseRPlotOrchestrator$extract_format_config_from_axis_calls()}}
\item \href{#method-BaseRPlotOrchestrator-extract_layout}{\code{BaseRPlotOrchestrator$extract_layout()}}
\item \href{#method-BaseRPlotOrchestrator-combine_layer_results}{\code{BaseRPlotOrchestrator$combine_layer_results()}}
\item \href{#method-BaseRPlotOrchestrator-generate_maidr_data}{\code{BaseRPlotOrchestrator$generate_maidr_data()}}
\item \href{#method-BaseRPlotOrchestrator-get_layout}{\code{BaseRPlotOrchestrator$get_layout()}}
\item \href{#method-BaseRPlotOrchestrator-get_combined_data}{\code{BaseRPlotOrchestrator$get_combined_data()}}
\item \href{#method-BaseRPlotOrchestrator-get_layer_processors}{\code{BaseRPlotOrchestrator$get_layer_processors()}}
\item \href{#method-BaseRPlotOrchestrator-get_layers}{\code{BaseRPlotOrchestrator$get_layers()}}
\item \href{#method-BaseRPlotOrchestrator-get_plot_calls}{\code{BaseRPlotOrchestrator$get_plot_calls()}}
\item \href{#method-BaseRPlotOrchestrator-get_gtable}{\code{BaseRPlotOrchestrator$get_gtable()}}
\item \href{#method-BaseRPlotOrchestrator-get_grob_for_layer}{\code{BaseRPlotOrchestrator$get_grob_for_layer()}}
\item \href{#method-BaseRPlotOrchestrator-has_unsupported_layers}{\code{BaseRPlotOrchestrator$has_unsupported_layers()}}
\item \href{#method-BaseRPlotOrchestrator-should_fallback}{\code{BaseRPlotOrchestrator$should_fallback()}}
\item \href{#method-BaseRPlotOrchestrator-clone}{\code{BaseRPlotOrchestrator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-new"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$new(device_id = grDevices::dev.cur())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-detect_layers"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-detect_layers}{}}}
\subsection{Method \code{detect_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$detect_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-analyze_single_layer"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-analyze_single_layer}{}}}
\subsection{Method \code{analyze_single_layer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$analyze_single_layer(
  plot_call,
  layer_index,
  group = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-create_layer_processors"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-create_layer_processors}{}}}
\subsection{Method \code{create_layer_processors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$create_layer_processors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-create_layer_processor"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-create_layer_processor}{}}}
\subsection{Method \code{create_layer_processor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$create_layer_processor(layer_info)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-create_unified_layer_processor"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-create_unified_layer_processor}{}}}
\subsection{Method \code{create_unified_layer_processor()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$create_unified_layer_processor(layer_info)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer_info}}{Layer information}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Layer processor instance
Extract Format Configuration from axis() Calls

Scans logged axis() calls for format config stored by the axis wrapper.
The wrapper stores .maidr_format_config when labels is a scales:: function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-process_layers"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-process_layers}{}}}
\subsection{Method \code{process_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$process_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-extract_format_config_from_axis_calls"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-extract_format_config_from_axis_calls}{}}}
\subsection{Method \code{extract_format_config_from_axis_calls()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$extract_format_config_from_axis_calls()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with x and/or y format configurations, or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-extract_layout"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-extract_layout}{}}}
\subsection{Method \code{extract_layout()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$extract_layout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-combine_layer_results"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-combine_layer_results}{}}}
\subsection{Method \code{combine_layer_results()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$combine_layer_results(layer_results)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-generate_maidr_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-generate_maidr_data}{}}}
\subsection{Method \code{generate_maidr_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$generate_maidr_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_layout"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_layout}{}}}
\subsection{Method \code{get_layout()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_layout()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_combined_data"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_combined_data}{}}}
\subsection{Method \code{get_combined_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_combined_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_layer_processors"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_layer_processors}{}}}
\subsection{Method \code{get_layer_processors()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_layer_processors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_layers"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_layers}{}}}
\subsection{Method \code{get_layers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_layers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_plot_calls"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_plot_calls}{}}}
\subsection{Method \code{get_plot_calls()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_plot_calls()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_gtable"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_gtable}{}}}
\subsection{Method \code{get_gtable()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_gtable()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-get_grob_for_layer"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-get_grob_for_layer}{}}}
\subsection{Method \code{get_grob_for_layer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$get_grob_for_layer(layer_index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-has_unsupported_layers"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-has_unsupported_layers}{}}}
\subsection{Method \code{has_unsupported_layers()}}{
Check if any HIGH-level layers are unsupported (unknown type)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$has_unsupported_layers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if there are unsupported layers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-should_fallback"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-should_fallback}{}}}
\subsection{Method \code{should_fallback()}}{
Determine if the plot should fall back to image rendering
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$should_fallback()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical indicating if fallback should be used
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseRPlotOrchestrator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseRPlotOrchestrator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseRPlotOrchestrator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
