% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unified_logger.R
\name{UnifiedLogger}
\alias{UnifiedLogger}
\title{Unified Logger for mLLMCelltype Package}
\description{
Unified Logger for mLLMCelltype Package

Unified Logger for mLLMCelltype Package
}
\details{
This logger provides centralized, multi-level logging with structured output,
log rotation, and performance monitoring capabilities.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{log_dir}}{Directory for storing log files}

\item{\code{log_level}}{Current logging level}

\item{\code{session_id}}{Unique identifier for the current session}

\item{\code{max_log_size}}{Maximum log file size in MB (default: 10MB)}

\item{\code{max_log_files}}{Maximum number of log files to keep (default: 5)}

\item{\code{enable_console}}{Whether to output to console (default: TRUE)}

\item{\code{enable_json}}{Whether to use JSON format (default: TRUE)}

\item{\code{performance_stats}}{Performance monitoring statistics}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UnifiedLogger-new}{\code{UnifiedLogger$new()}}
\item \href{#method-UnifiedLogger-debug}{\code{UnifiedLogger$debug()}}
\item \href{#method-UnifiedLogger-info}{\code{UnifiedLogger$info()}}
\item \href{#method-UnifiedLogger-warn}{\code{UnifiedLogger$warn()}}
\item \href{#method-UnifiedLogger-error}{\code{UnifiedLogger$error()}}
\item \href{#method-UnifiedLogger-log_api_call}{\code{UnifiedLogger$log_api_call()}}
\item \href{#method-UnifiedLogger-log_api_request_response}{\code{UnifiedLogger$log_api_request_response()}}
\item \href{#method-UnifiedLogger-log_cache_operation}{\code{UnifiedLogger$log_cache_operation()}}
\item \href{#method-UnifiedLogger-log_cluster_progress}{\code{UnifiedLogger$log_cluster_progress()}}
\item \href{#method-UnifiedLogger-log_discussion}{\code{UnifiedLogger$log_discussion()}}
\item \href{#method-UnifiedLogger-log_model_response}{\code{UnifiedLogger$log_model_response()}}
\item \href{#method-UnifiedLogger-get_performance_summary}{\code{UnifiedLogger$get_performance_summary()}}
\item \href{#method-UnifiedLogger-cleanup_logs}{\code{UnifiedLogger$cleanup_logs()}}
\item \href{#method-UnifiedLogger-set_level}{\code{UnifiedLogger$set_level()}}
\item \href{#method-UnifiedLogger-clone}{\code{UnifiedLogger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-new"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-new}{}}}
\subsection{Method \code{new()}}{
Initialize the unified logger
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$new(
  base_dir = "logs",
  level = "INFO",
  max_size = 10,
  max_files = 5,
  console_output = TRUE,
  json_format = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-debug"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-debug}{}}}
\subsection{Method \code{debug()}}{
Log a debug message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$debug(message, context = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-info"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-info}{}}}
\subsection{Method \code{info()}}{
Log an info message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$info(message, context = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-warn"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-warn}{}}}
\subsection{Method \code{warn()}}{
Log a warning message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$warn(message, context = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-error"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-error}{}}}
\subsection{Method \code{error()}}{
Log an error message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$error(message, context = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_api_call}{}}}
\subsection{Method \code{log_api_call()}}{
Log API call performance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_api_call(
  provider,
  model,
  duration,
  success = TRUE,
  tokens = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_api_request_response"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_api_request_response}{}}}
\subsection{Method \code{log_api_request_response()}}{
Log complete API request and response for debugging and audit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_api_request_response(
  provider,
  model,
  prompt_content,
  response_content,
  request_metadata = NULL,
  response_metadata = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_cache_operation"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_cache_operation}{}}}
\subsection{Method \code{log_cache_operation()}}{
Log cache operations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_cache_operation(operation, key, size = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_cluster_progress"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_cluster_progress}{}}}
\subsection{Method \code{log_cluster_progress()}}{
Log cluster annotation progress
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_cluster_progress(cluster_id, stage, progress = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_discussion"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_discussion}{}}}
\subsection{Method \code{log_discussion()}}{
Log detailed cluster discussion with complete model conversations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_discussion(cluster_id, event_type, data = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-log_model_response"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-log_model_response}{}}}
\subsection{Method \code{log_model_response()}}{
Log model response with concise summary in main log and full text in file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$log_model_response(
  provider,
  model,
  response,
  stage = "annotation",
  cluster_id = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-get_performance_summary"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-get_performance_summary}{}}}
\subsection{Method \code{get_performance_summary()}}{
Get performance summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$get_performance_summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-cleanup_logs"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-cleanup_logs}{}}}
\subsection{Method \code{cleanup_logs()}}{
Clean up old log files
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$cleanup_logs(force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-set_level"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-set_level}{}}}
\subsection{Method \code{set_level()}}{
Set logging level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$set_level(level)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UnifiedLogger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UnifiedLogger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnifiedLogger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
