% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_features}
\alias{plot_features}
\title{Plot the features in an explanation}
\usage{
plot_features(explanation, ncol = 2, cases = NULL)
}
\arguments{
\item{explanation}{A \code{data.frame} as returned by \code{\link[=explain]{explain()}}.}

\item{ncol}{The number of columns in the facetted plot}

\item{cases}{An optional vector with case names to plot. \code{explanation} will
be filtered to only include these cases prior to plotting}
}
\value{
A \code{ggplot} object
}
\description{
This functions creates a compact visual representation of the explanations
for each case and label combination in an explanation. Each extracted feature
is shown with its weight, thus giving the importance of the feature in the
label prediction.
}
\examples{
# Create some explanations
library(MASS)
iris_test <- iris[1, 1:4]
iris_train <- iris[-1, 1:4]
iris_lab <- iris[[5]][-1]
model <- lda(iris_train, iris_lab)
explanation <- lime(iris_train, model)
explanations <- explain(iris_test, explanation, n_labels = 1, n_features = 2)

# Get an overview with the standard plot
plot_features(explanations)

}
\seealso{
Other explanation plots: 
\code{\link{plot_explanations}()},
\code{\link{plot_text_explanations}()}
}
\concept{explanation plots}
