% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-name.R
\name{likelihood_name}
\alias{likelihood_name}
\title{Likelihood model generator for standard R distributions}
\usage{
likelihood_name(dist_name, ob_col, censor_col = NULL, ob_col_upper = NULL)
}
\arguments{
\item{dist_name}{The name of the distribution (e.g., "norm", "weibull", "exp")}

\item{ob_col}{The name of the column containing observations (lower bound
for interval-censored data)}

\item{censor_col}{The name of the column containing censoring type, or NULL
for all exact observations. Valid values: "exact", "left", "right",
"interval", or NA.}

\item{ob_col_upper}{The name of the column containing the upper bound for
interval-censored observations, or NULL if no interval censoring is used.}
}
\value{
A likelihood model object
}
\description{
Creates a likelihood model based on R's distribution naming convention,
where distributions have functions named \code{d<name>} (PDF), \code{p<name>} (CDF),
\code{q<name>} (quantile), and \code{r<name>} (random generation).
}
\details{
The model automatically handles exact and censored observations:
\itemize{
\item Exact: uses PDF (\code{d<name>})
\item Left-censored: uses CDF (\code{p<name>})
\item Right-censored: uses survival function (1 - CDF)
}
}
\examples{
# Simple case - all exact observations
model <- likelihood_name("norm", ob_col = "x")
df <- data.frame(x = rnorm(100))
ll <- loglik(model)
ll(df, c(mean = 0, sd = 1))

# With censoring
model <- likelihood_name("weibull", ob_col = "time", censor_col = "status")
df <- data.frame(time = rweibull(100, 2, 1),
                 status = sample(c("exact", "right"), 100, replace = TRUE))

# With interval censoring
model <- likelihood_name("norm", ob_col = "x", censor_col = "censor",
                         ob_col_upper = "x_upper")
}
