# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# countries_pts

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("countries_pts is a data.frame", {
  expect_s3_class(countries_pts, "data.frame")
})

# Test 2: Confirm it has exactly 4 columns
test_that("countries_pts has 4 columns", {
  expect_equal(length(countries_pts), 4)
})

# Test 3: Confirm it has exactly 245 rows
test_that("countries_pts has 245 rows", {
  expect_equal(nrow(countries_pts), 245)
})

# Test 4: Confirm column names are correct
test_that("countries_pts has correct column names", {
  expect_named(countries_pts, c("country", "latitude", "longitude", "name"))
})

# Test 5: Confirm column types are as expected
test_that("countries_pts columns have correct types", {
  expect_type(countries_pts$country, "character")
  expect_type(countries_pts$latitude, "double")
  expect_type(countries_pts$longitude, "double")
  expect_type(countries_pts$name, "character")
})
