% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_financialFunctions.R
\name{nominal2Real}
\alias{nominal2Real}
\alias{convertible2Effective}
\alias{real2Nominal}
\alias{effective2Convertible}
\title{Functions to switch from nominal / effective / convertible rates}
\usage{
nominal2Real(i, k = 1, type = "interest")

convertible2Effective(i, k = 1, type = "interest")

real2Nominal(i, k = 1, type = "interest")

effective2Convertible(i, k = 1, type = "interest")
}
\arguments{
\item{i}{The rate to be converted.}

\item{k}{The original / target compounting frequency.}

\item{type}{Either "interest" (default) or "nominal".}
}
\value{
A numeric value.
}
\description{
Functions to switch from nominal / effective / convertible rates
}
\details{
\code{effective2Convertible} and \code{convertible2Effective} wrap the other two functions.
}
\note{
Convertible rates are synonims of nominal rates
}
\examples{
#a nominal rate of 0.12 equates an APR of
nominal2Real(i=0.12, k = 12, "interest")
}
\references{
Broverman, S.A., Mathematics of Investment and Credit (Fourth Edition), 2008, ACTEX Publications.
}
\seealso{
\code{\link{real2Nominal}}
}
