% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_level.R
\name{plot.retlev}
\alias{plot.retlev}
\title{Plot diagnostics for a retlev object}
\usage{
\method{plot}{retlev}(x, y = NULL, level = NULL, legend = TRUE, digits = 3, plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{c("retlev", "lax")}, a result of
a call to \code{\link{return_level}}, using \code{prof = TRUE}.}

\item{y}{Not used.}

\item{level}{A numeric scalar in (0, 1).  The confidence level required for
the confidence interval for the \code{m}-year return level.
If \code{level} is not supplied then \code{x$level} is used.
\code{level} must be no larger than \code{x$level}.}

\item{legend}{A logical scalar.  Should we add a legend (in the top right
of the plot) that gives the approximate values of the MLE and
100\code{level}\% confidence limits?}

\item{digits}{An integer. Passed to \code{\link[base:Round]{signif}} to
round the values in the legend.}

\item{plot}{A logical scalar.  If \code{TRUE} then the plot is produced.
Otherwise, it is not, but the MLE and confidence limits are returned.}

\item{...}{Further arguments to be passed to
\code{\link[graphics:plot.default]{plot}}.}
}
\value{
A numeric vector of length 3 containing the lower
  100\code{level}\% confidence limit, the MLE and the upper
  100\code{level}\% confidence limit.
}
\description{
\code{plot} method for an objects of class \code{c("retlev", "lax")}.
}
\details{
Plots the profile loglikelihood for a return level, provided that
  \code{x} returned by a call to \code{\link{return_level}} using
  \code{prof = TRUE}.  Horizontal lines indicate the values of the
  maximised loglikelihood and the critical level used to calculate
  the confidence limits.
  If \code{level} is smaller than \code{x$level} then approximate
  100\code{level}\% confidence limits are recalculated based on the
  information contained in \code{x$for_plot}.
}
\section{Examples}{

See the examples in \code{\link{return_level}}.
}

\seealso{
\code{\link{return_level}} to perform inferences about return
  levels.
}
