% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_pca.R
\name{kPCA}
\alias{kPCA}
\title{Kernel PCA}
\usage{
kPCA(
  K,
  center = TRUE,
  Ktest = NULL,
  plot = NULL,
  y = NULL,
  colors = "black",
  na_col = "grey70",
  title = "Kernel PCA",
  pos_leg = "right",
  name_leg = "",
  labels = NULL,
  ellipse = NULL
)
}
\arguments{
\item{K}{Kernel matrix (class "matrix").}

\item{center}{A logical value. If TRUE, the variables are zero-centered before
the PCA. (Defaults: TRUE).}

\item{Ktest}{(optional) An additional kernel matrix corresponding to test samples,
with dimension \emph{Ntest x Ntraining}. These new samples are projected
(using the color defined by `na_col`) over the kernel PCA computed from K.
Remember than the data that generated `Ktest` should be centered beforehand, using
the same values used for centering `K`.}

\item{plot}{(optional) A `ggplot2` is displayed. The input should be a vector of
integers with length 2, corresponding to the two Principal Components to be displayed in the plot.}

\item{y}{(optional) A factor, or a numeric vector, with length equal to `nrow(K)`
(number of samples). This parameter allows to paint the points with different colors.}

\item{colors}{A single color, or a vector of colors. If `y` is numeric, a gradient of colors
between the first and the second entry will be used to paint the points. (Defaults: "black").}

\item{na_col}{Color of the entries that have a NA in the parameter `y`, or the entries
corresponding to `Ktest` (when `Ktest` is not NULL). Otherwise, this parameter is ignored.}

\item{title}{Plot title.}

\item{pos_leg}{Position of the legend.}

\item{name_leg}{Title of the legend. (Defaults: blank)}

\item{labels}{(optional) A vector of the same length than nrow(K). A name will be
displayed next to each point.}

\item{ellipse}{(optional) A float between 0 and 1. An ellipse will be drawn for
each group of points defined by `y`. Here `y` should be of class "factor." This
parameter will indicate the spread of the ellipse.}
}
\value{
A list with two objects:

* The PCA projection (class "matrix"). Please note that if K was computed from a \emph{NxD}
table with \emph{N > D}, only the first \emph{N-D} PCs may be useful.

* (optional) A `ggplot2` plot of the selected PCs.
}
\description{
`kPCA()` computes the kernel PCA from a kernel matrix and, if desired, produces
a plot. The contribution of the original variables to the Principal Components (PCs),
sometimes referred as "loadings", is NOT returned (to do so, go to `kPCA_imp()`).
}
\details{
As the ordinary PCA, kernel PCA can be used to summarize, visualize and/or
create new features of a dataset. Data can be projected in a linear or nonlinear
way, depending on the kernel used. When the kernel is `Linear()`, kernel PCA
is equivalent to ordinary PCA.
}
\examples{
dat <- matrix(rnorm(150),ncol=50,nrow=30)
K <- Linear(dat)

## Projection's coordinates only:
pca <- kPCA(K)

## Coordinates + plot of the two first principal components (PC1 and PC2):
pca <- kPCA(K,plot=1:2, colors = "coral2")
pca$plot
}
