% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py-classes.R
\name{\%<-active\%}
\alias{\%<-active\%}
\title{Make an Active Binding}
\usage{
sym \%<-active\% value
}
\arguments{
\item{sym}{symbol to bind}

\item{value}{A function to call when the value of \code{sym} is accessed.}
}
\value{
\code{value}, invisibly
}
\description{
Make an Active Binding
}
\details{
Active bindings defined in a \verb{\%py_class\%} are converted to
\verb{@property} decorated methods.
}
\examples{
set.seed(1234)
x \%<-active\% function(value) {
  message("Evaluating function of active binding")
  if(missing(value))
    runif(1)
  else
   message("Received: ", value)
}
x
x
x <- "foo"
x <- "foo"
x
rm(x) # cleanup
}
\seealso{
\code{\link[=makeActiveBinding]{makeActiveBinding()}}
}
