% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_exporter_functions.R
\name{theme_docx_default_j}
\alias{theme_docx_default_j}
\title{Obtain the default theme for the docx}
\usage{
theme_docx_default_j(
  font = "Times New Roman",
  font_size = 9L,
  cell_margins = c(0, 0, 0, 0),
  bold = c("header", "content_rows", "label_rows", "top_left"),
  bold_manual = NULL,
  border = flextable::fp_border_default(width = 0.75, color = "black")
)
}
\arguments{
\item{font}{(\code{string})\cr font. Defaults to "Times New Roman".}

\item{font_size}{(\code{integer(1)})\cr font size. Defaults to 9.}

\item{cell_margins}{(\verb{numeric(1) or numeric(4)})\cr
a numeric or a vector of four numbers indicating
c("left", "right", "top", "bottom"). It defaults to 0mm in Word pt to all 4 margins.}

\item{bold}{(\code{character})\cr parts of the table text that should be in bold.
Can be any combination of c("header", "content_rows", "label_rows", "top_left").
The first one renders all column names bold (not topleft content).
The second and third option use formatters::make_row_df() to render
content or/and label rows as bold.}

\item{bold_manual}{(\verb{named list or NULL})\cr list of index lists.
See example for needed structure. Accepted groupings/names are c("header", "body").}

\item{border}{(\code{fp_border})\cr border to use. Defaults to width = 0.75
and color = "black"}
}
\value{
a function that applies the given theme to a flextable.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is based on \code{\link[rtables.officer:tt_to_flextable]{rtables.officer::theme_docx_default()}}.
See notes to understand why this is experimental.
}
\note{
This function has been tested for common use cases but may not work or have
unexpected or undesired behavior in corner cases. As such it is not considered
fully production ready and is being made available for further testing
and early adoption. Please report any issues you encounter to the developers.
This function may be removed from junco in the future if the functionality
is merged into \code{rtables.officer}.
}
