% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensemakr.R
\name{ovb_minimal_reporting}
\alias{ovb_minimal_reporting}
\title{Minimal sensitivity reporting for IV estimates}
\usage{
ovb_minimal_reporting(
  x,
  digits = 3,
  verbose = TRUE,
  format = c("latex", "html", "pure_html"),
  ...
)
}
\arguments{
\item{x}{an object of class \code{iv.sensemakr} or \code{sensemakr}.}

\item{digits}{minimal number of \emph{significant} digits.}

\item{verbose}{if \code{TRUE}, the function prints the code with \code{\link{cat}}.}

\item{format}{code format to print: \code{"latex"}, \code{"html"} (requires mathjax), or \code{"pure_html"}.}

\item{...}{further arguments passed to the table-building functions.
Optional overrides include \code{outcome_label} and \code{treatment_label}.}
}
\value{
The function returns the LaTeX or HTML code invisibly as a character string and also prints it
with \code{\link{cat}} when \code{verbose = TRUE}.
}
\description{
This function produces LaTeX or HTML code for a minimal sensitivity analysis table
for instrumental variable estimates, as suggested in Cinelli and Hazlett (2025).
For objects of class \code{\link{sensemakr}} (from the \pkg{sensemakr} package), it
dispatches to \code{sensemakr::\link[sensemakr]{ovb_minimal_reporting}}.
}
\examples{
# loads package
library(iv.sensemakr)

# loads dataset
data("card")

# prepares data
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)

# fits IV model and runs sensitivity analysis
card.fit <- iv_fit(y, d, z, x)
card.sens <- sensemakr(card.fit, benchmark_covariates = c("black", "smsa"))

# latex code
ovb_minimal_reporting(card.sens)

# html code (pure html, no mathjax needed)
ovb_minimal_reporting(card.sens, format = "pure_html")

}
\references{
Cinelli, C. and Hazlett, C. (2025), "An Omitted Variable Bias Framework for Sensitivity Analysis of Instrumental Variables." Biometrika. \doi{10.1093/biomet/asaf004}
}
