% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipea_palette.R
\name{ipea_palette}
\alias{ipea_palette}
\title{Ipea Color Palette and Scales}
\usage{
ipea_palette(
  palette = c("Blue", "Green", "Orange", "Pink", "Green-Blue", "Green-Blue-White",
    "Red-Blue", "Red-Blue-White", "Orange-Blue", "Orange-Blue-White", "Viridis",
    "Inferno", "Magma", "Plasma", "Cividis"),
  n,
  alpha = 1,
  begin = 0,
  end = 1,
  palette_direction = 1
)
}
\arguments{
\item{palette}{A character string indicating the color map option to use.
These options are available:'Blue', 'Green', 'Orange', 'Pink', 'Red-Blue'
'Orange-Blue', 'Green-Blue', 'Red-Blue-White', 'Orange-Blue-White',
'Green-Blue-White', 'Viridis', 'Inferno', 'Magma', 'Plasma', 'Cividis'.}

\item{n}{The number of colors (\eqn{\ge 1}) used in the palette.}

\item{alpha}{The alpha transparency in a number between \code{0} and \code{1}.}

\item{begin}{The (corrected) hue in a number between \code{0} and \code{1} at which the
color map begins.}

\item{end}{The (corrected) hue in a number between \code{0} and \code{1} at which the
color map ends.}

\item{palette_direction}{Sets the order of colors in the scale. If \code{1}, the default,
colors are ordered from darkest to lightest. If \code{-1}, the order of
colors is reversed.}
}
\value{
\code{ipea_palette} produces a character vector, \code{cv}, containing color hex codes.
This vector can be utilized to establish a custom color scheme for future graphics using \code{palette(cv)},
or it can be applied directly as a \code{col =} parameter in graphic functions or within \code{par}.
}
\description{
This function creates a vector of n equally spaced colors
along the selected color map.
}
\details{
A 9-color Ipea palette.
}
\references{
'Blue','Green','Orange','Pink','Green-Blue','Green-Blue-White','Red-Blue','Red-Blue-White',
'Orange-Blue','Orange-Blue-White', 'Viridis','Inferno',
'Magma','Plasma' and 'Cividis': https://pmassicotte.github.io/paletteer_gallery/
}
